Serdecznie witam w książce Nowoczesny Linux. Bardzo się cieszę z powodu tej podróży, którą wspólnie odbędziemy. Ta książka jest przeznaczona dla Ciebie, jeśli już używasz Linuksa i chcesz jeszcze dokładniej poznać ten system, więc szukasz strukturalnego i bazującego na przykładach podejścia, bądź też masz doświadczenie w pracy z Linuksem i chcesz poznać pewne sztuczki i rozwiązania pozwalające usprawnić pracę z Linuksem — np. w profesjonalnej konfiguracji, takiej jak środowisko przeznaczone do programowania lub operacyjne.

Dzięki lekturze książki zdobędziesz doświadczenie w pracy z nowoczesnymi terminalami i powłokami systemu Linux oraz nauczysz się zarządzać pracą w nowoczesny sposób. Dowiesz się również, jak w nowoczesny sposób uruchamiać aplikacje systemu Linux, używając do tego kontenerów, `systemd`, nowoczesnych systemów plików oraz niemodyfikowalnych dystrybucji, takich jak Flatcar i Bottlerocket.

![book cover](lml-cover.png)

Okładna książki [dostępna w serwisie O'Reilly](https://learning.oreilly.com/library/view/learning-modern-linux/9781098108939/). 
Jeżeli masz uwagi lub komentarze, napisz do mnie: [modern-linux@pm.me](mailto:modern-linux@pm.me).

Dostępne są również materiały dodatkowe dla książki:

1. Kolekcja [odniesień](odniesienia) zawierająca łącza do artykułów i narzędzi
2. [Fragmenty kodów i pliki konfiguracyjne](https://github.com/mhausenblas/modern-linux.info/tree/main/code)


## Zawartość

### Rozdział 1. Wprowadzenie do Linuksa

> Przede wszystkim wyjaśnię, co w kontekście książki oznacza słowo „nowoczesny”. Następnie przedstawię ogólną historię Linuksa oraz najważniejsze wydarzenia i etapy w ciągu jego 30-letniej historii. Poznasz również ogólną rolę systemu operacyjnego i zobaczysz, jak Linux ją pełni. Ponadto pokrótce wyjaśnię, czym są dystrybucje systemu Linux oraz co oznacza widoczność zasobów.

* Czym jest nowoczesne środowisko?
* Historia Linuksa
* Do czego służy system operacyjny?
* Dystrybucje Linuksa
* Dostępność zasobu

### Rozdział 2. Jądro Linuksa

> W tym rozdziale natomiast wyjaśnię, czym jest jądro Linuksa i jak należy je traktować, zarówno jako całość, jak i jego komponenty. Poznasz ogólną architekturę Linuksa, a także ważną rolę, jaką odgrywa jądro. Z lektury rozdziału trzeba zapamiętać, że wprawdzie jądro dostarcza podstawową funkcjonalność systemu, ale mimo to nie jest systemem operacyjnym, lecz jedynie jego ważną częścią.

* Architektura Linuksa
* Architektura procesora
* Komponenty jądra
* Rozszerzenia jądra

### Rozdział 3. Powłoki i skrypty

> W tym rozdziale skoncentruję się na pracy z Linuksem w terminalu, czyli za pomocą powłoki, która udostępnia interfejs wiersza poleceń (ang. command-line interface, CLI). Dalej pokrótce przedstawię nowoczesne i przyjazne użytkownikowi powłoki, takie jak `fish`. Omówię także konfigurację i najczęściej wykonywane zadania w powłoce. Następnie przejdę do tematu efektywnej pracy z interfejsem wiersza poleceń z użyciem multipleksera terminala (`tmux`), który umożliwi pracę z wieloma sesjami, zarówno lokalnymi, jak i zdalnymi. Natomiast w ostatniej części rozdziału skoncentruję się na automatyzacji zadań w powłoce za pomocą skryptów. Przedstawię przy tym najlepsze praktyki w zakresie tworzenia skryptów w sposób bezpieczny i przenośny, a także pokażę, jak lintować i testować skrypty.

* Podstawy
* Powłoki przyjazne użytkownikowi
* Multiplekser terminala
* Skrypty

### Rozdział 4. Kontrola dostępu

> W tym rozdziale skoncentruję się na jednym konkretnym i ważnym aspekcie Linuksa, jakim są użytkownicy i kontrola dostępu do zasobów, zarówno ogólnie, jak i na poziomie poszczególnych plików.

* Użytkownicy
* Uprawnienia
* Zaawansowane zarządzanie uprawnieniami
* Dobre praktyki

### Rozdział 5. Systemy plików

> W tym rozdziale skoncentruję się na plikach i systemach plików. Następnie przejdę do omówienia sposobu implementacji w Linuksie abstrakcji „wszystko jest plikiem”. Kolejnym krokiem będzie omówienie systemów plików specjalnego przeznaczenia, których jądro używa do udostępniania informacji o procesach i urządzeniach. Później przejdę do zwykłych plików i systemów plików, czyli tego, co zwykle użytkownik kojarzy z dokumentami, danymi i programami. Porównam także opcje systemu plików oraz przedstawię najczęściej przeprowadzane operacje.
  
* Podstawy
* Wirtualny system plików
* Pseudosystemy plików
* Zwykłe pliki

### Rozdział 6. Aplikacje, kontenery i zarządzanie pakietami

> W tym rozdziale poruszę temat aplikacji w Linuksie. Dowiesz się, jak odbywa się proces uruchamiania Linuksa i wszystkich jego usług zależnych. Następnie przejdę do tematu zarządzania pakietami. Zacznę od ogólnego omówienia łańcucha dostaw.  W kolejnym podrozdziale skoncentruję się na kontenerach: czym są i jak działają. Na zakończenie rozdziału przedstawię nowoczesne sposoby zarządzania aplikacjami Linuksa, zwłaszcza w środowiskach graficznych.

* Podstawy
* Proces rozruchu Linuksa
* Łańcuch dostaw aplikacji Linuksa
* Pakiety i menedżery pakietów
* Kontenery
* Nowoczesne menedżery pakietów

### Rozdział 7. Sieć

> W tym rozdziale szczegółowo omówię sieć w Linuksie. W nowoczesnych środowiskach dostarczany przez Linuksa stos sieciowy jest istotnym komponentem. Bez niego możliwości są znacznie mniejsze. Niezależnie od tego, czy chcesz uzyskać dostęp do egzemplarza oferowanego przez dostawcę chmury, przeglądać zasoby internetu czy zainstalować nową aplikację, potrzebujesz połączenia z siecią oraz możliwości jego używania.

* Stos TCP/IP
* DNS
* Sieć warstwy aplikacji
* Zaawansowane zagadnienia dotyczące sieci

### Rozdział 8. Obserwacja systemu

> Tematem tego rozdziału jest zbieranie i używanie różnych sygnałów, które Linux i jego aplikacje generują, aby umożliwić użytkownikowi świadome podejmowanie decyzji. Dzięki tym sygnałom zyskujesz różne możliwości, np.: określenie ilości pamięci zużywanej przez proces; ustalenie, kiedy skończy się dostępne miejsce na dysku; otrzymywanie (ze względów bezpieczeństwa) powiadomień o niestandardowych zdarzeniach. Innymi słowy musisz wiedzieć, co się dzieje na stosie — od jądra po komponenty dostępne dla użytkownika. Taką wiedzę bardzo często zapewnisz sobie dzięki użyciu odpowiedniego narzędzia dla danego zadania.

* Podstawy
* Rejestrowanie danych
* Monitorowanie
* Zaawansowana obserwacja

### Rozdział 9. Tematy zaawansowane
> Ten rozdział zawiera różności. Poruszyłem w nim wiele tematów, od maszyn wirtualnych, poprzez zapewnienie bezpieczeństwa, po nowe sposoby używania systemu Linux. Wspólnym mianownikiem zagadnień omówionych w tym rozdziale jest to, że większość z nich będzie miała znaczenie tylko w przypadkach specjalnych lub gdy będą wymagane w profesjonalnej pracy.

* Komunikacja międzyprocesowa
* Maszyny wirtualne
* Nowoczesne dystrybucje Linuksa
* Wybrane zagadnienia z zakresu bezpieczeństwa
* Inne nowoczesne i przyszłe dystrybucje

### Dodatek A. Użyteczne receptury
> W tym dodatku zamieściłem listę receptur dla najczęściej wykonywanych zadań. To tylko niektóre receptury z zebranych przeze mnie na przestrzeni czasu i dotyczą zadań, które wykonuję najczęściej.

### Dodatek B. Nowoczesne narzędzia Linuksa
> W tym dodatku skoncentruję się na nowoczesnych narzędziach i poleceniach systemu Linux. Część z nich to bezpośrednie zamienniki istniejących poleceń, z kolei inne to zupełnie nowe narzędzia. Większość wymienionych tutaj ma na celu poprawienie wrażeń użytkownika (ang. user experience, UX), np. przez prostszy sposób użycia i wygenerowanie kolorowych danych wyjściowych, co pozwala na znacznie efektywniejszą pracę.
